state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

local welder = resize.location.welder
local mirror_in = resize.location.std.generators[1].mirror
local mirror_out = resize.location.std.checkers[1].mirror

function is_welder_selected()
  local partial = state:get_partial_interaction()
  return partial.type == "PartialPlaceCompound"
end
local function only_open_welder(i)
  return i.type == "PlaceBlueprintAction"
end
local function is_mouse_interaction(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.rmb_click or i.event == MouseEventAction.lmb_click then
      return true
    end
  elseif i.type == "MouseUpdateAction" then
    return i.lmb == MOUSE_NONE
  end
  return false
end
function is_done()
  for v in each_vector(welder) do
    if state.grid:at(v) == nil then
      return false
    end
  end
  return true
end
function speed_is_low()
  return state:get_simulation_speed() < 1.5;
end
function tutorial_routine()
  return coroutine.wrap(function()
    if not is_done() then
      set_user_input_filter(restrictive_filter)
      embed(ramp(3, do_all(
        announce_lambda("Here, we receive single blocks...", 0.1),
        blinking_box_at_game_lambda(mirror_in)
      ), captured_cancel()))
      embed(ramp(3, do_all(
        announce_lambda("...but must produce rows of 5", 0.1),
        blinking_box_at_game_lambda(mirror_out)
      ), captured_cancel()))
    end
    state:suppress_toolbar_menu(false)
    while not is_done() do
      set_user_input_filter(only_open_welder)
      embed(ramp_until(is_welder_selected, do_all(
        highlight_menu_item_lambda("toolbar_4"),
        announce_lambda("Tool: Welder", 0.15))
      ))
      set_user_input_filter(is_mouse_interaction)
      embed(ramp_while(
        lifted_and(
          is_welder_selected,
          lifted_not(is_done)
        ),
        do_all(
          announce_lambda("Place the welder here.", 0.1),
          bouncing_arrow_at_game_lambda(welder, 0.06, DOWN),
          glowing_box_at_game_lambda(welder)
        )
      ))
    end
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_or_speed_or_cancel_filter)
    embed(ramp_while(is_welder_selected, announce_lambda("Right click to close welder tool", 0.08)))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
    embed(pause_until(function() return state.grid:ticks() >= 16 end))
    embed(ramp(3, announce_lambda("Welders weld whatever is in front of them.", 0.075), captured_cancel()))
    embed(pause(5))
    embed(ramp_while(speed_is_low, do_all(
      announce_lambda("Remember that you can adjust the speed.", 0.065),
      highlight_menu_item_lambda("speed_control")
    )))
  end)
end

draw_interpreted_routine(tutorial_routine())

state:filter_interactions(function(i)
  if i.type == "Place" then
    if welder:contains(i.where.position) then
      return
    else
      return "Cannot place outside of the designated area."
    end
  elseif i.type == "Join" then
    return true
  else
    return "Can only place a welder on this level."
  end
end)
